package com.ld.sdk.ldsdkdemo;

import android.app.Activity;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Toast;

import com.ld.sdk.LdGameInfo;
import com.ld.sdk.LdPayInfo;
import com.ld.sdk.LdSdkManger;
import com.ld.sdk.account.api.EntryCallback;
import com.ld.sdk.account.api.ExitCallBack;
import com.ld.sdk.account.api.InitCallBack;
import com.ld.sdk.account.api.LoginCallBack;
import com.ld.sdk.account.api.PayCallback;
import com.ld.sdk.account.api.UserEmpowerCallback;

import java.util.Random;

public class MainActivity extends Activity {

    private static final String APP_SECRET_ID = "95974a4835f5121d3edeedd61ae27cea";  //AppKey

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        // 去掉窗口标题
        requestWindowFeature(Window.FEATURE_NO_TITLE);
        // 隐藏顶部的状态栏
        getWindow().addFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN);
        setContentView(R.layout.activity_main);
        initView();
    }

    private void initView() {
        LdSdkManger.getInstance().checkUserEmpower(this, "", new UserEmpowerCallback() {
            @Override
            public void callback(boolean isEmpower) {
                if (isEmpower) {
                    LdSdkManger.getInstance().init(MainActivity.this, APP_SECRET_ID, new InitCallBack() {

                        @Override
                        public void onSuccess() {
                            Toast.makeText(MainActivity.this, "初始化成功", Toast.LENGTH_SHORT).show();
                        }

                        @Override
                        public void onFail(String desc) {
                            Toast.makeText(MainActivity.this, desc, Toast.LENGTH_SHORT).show();
                        }
                    });
                } else {
                    finish();
                }
            }
        });

        Button loginBtn = (Button) findViewById(R.id.loginBtn);
        loginBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                LdSdkManger.getInstance().showLoginView(MainActivity.this, new LoginCallBack() {

                    @Override
                    public void loginSuccess(String s, String s1, String s2) {
                        Toast.makeText(MainActivity.this, "登录成功", Toast.LENGTH_SHORT).show();
                    }

                    @Override
                    public void loginFail(String desc) {
                        Toast.makeText(MainActivity.this, desc, Toast.LENGTH_SHORT).show();
                    }

                    @Override
                    public void loginLogout() {
                        Toast.makeText(MainActivity.this, "退出登录", Toast.LENGTH_SHORT).show();
                    }

                    @Override
                    public void accountCancellation() {
                        Toast.makeText(MainActivity.this, "注销账号", Toast.LENGTH_SHORT).show();
                    }

                    @Override
                    public void exitGame() {
                        finish();
                    }
                });

            }
        });

        Button entryGameBtn = (Button) findViewById(R.id.entryGameBtn);
        entryGameBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

                LdGameInfo ldGameInfo = new LdGameInfo();
                ldGameInfo.serverId = "23";// 服务器id
                ldGameInfo.serverName = "内测服";//服务器名字
                ldGameInfo.roleId = "10086";// 角色id
                ldGameInfo.roleName = "张三";// 角色名字
                ldGameInfo.roleType = ""; //角色类型，例如：战士，魔法师，弓箭手
                ldGameInfo.level = "99"; //等级
                ldGameInfo.money = "10000000000000"; //游戏的金币数
                ldGameInfo.partyName = "工会";//公会
                ldGameInfo.powerNum = 10000;
                ldGameInfo.vipLevel = 12;

                LdSdkManger.getInstance().enterGame(MainActivity.this, ldGameInfo, new EntryCallback() {
                    @Override
                    public void callback(int code, String desc) {
                        if (code == 0) {
                            Toast.makeText(MainActivity.this, "角色信息上传成功", Toast.LENGTH_LONG).show();
                        } else {
                            Toast.makeText(MainActivity.this, desc, Toast.LENGTH_LONG).show();
                        }
                    }
                });
            }
        });


        final EditText amountEdit = (EditText) findViewById(R.id.amountEdit);
        Button payBtn = (Button) findViewById(R.id.payBtn);
        payBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

                String amount = amountEdit.getText().toString();
                if ("".equals(amount)) {
                    Toast.makeText(MainActivity.this, "输入错误", Toast.LENGTH_SHORT).show();
                    return;
                }

                LdPayInfo ldPayInfo = new LdPayInfo();

                Random random = new Random();
                ldPayInfo.orderId = random.nextInt(10000) + random.nextInt(10000) + "";

                ldPayInfo.amount = amount;//支付金额（单位：分）
                ldPayInfo.productId = "12";  //定额的产品支付，暂时没用到，默认值

                ldPayInfo.productDesc = "充值金币";//商品描述
                ldPayInfo.productName = "金币";//商品名称
                ldPayInfo.roleId = "10086";// 角色id
                ldPayInfo.roleName = "张三";// 角色名字
                ldPayInfo.serverId = "23";// 服务器id
                ldPayInfo.serverName = "内测服";//服务器名字

                LdSdkManger.getInstance().showChargeView(MainActivity.this, ldPayInfo, new PayCallback() {
                    @Override
                    public void paySuccess(String uid, String orderId, String time) {
                        Toast.makeText(MainActivity.this, "支付成功", Toast.LENGTH_SHORT).show();
                    }

                    @Override
                    public void payFail(String desc) {
                        Toast.makeText(MainActivity.this, desc, Toast.LENGTH_SHORT).show();
                    }

                    @Override
                    public void payCancel() {
                        Toast.makeText(MainActivity.this, "支付取消", Toast.LENGTH_SHORT).show();
                    }
                });
            }
        });
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        System.exit(0);
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == KeyEvent.KEYCODE_BACK) {
            //返回键，退出接口
            LdSdkManger.getInstance().showExitView(this, new ExitCallBack() {

                @Override
                public void onFinish(int i, String s) {
                    if (i == 0) {
                        MainActivity.this.finish();
                    }
                }

            });
        }
        return false;
    }
}